<?php
// Turn on error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>AWS S3 Connection Test</h1>";

// Define ROOT if not defined
if (!defined('ROOT')) {
    define('ROOT', __DIR__);
}
if (!defined('DS')) {
    define('DS', DIRECTORY_SEPARATOR);
}

// 1. Load Constants
$constantPath = __DIR__ . '/app/Config/constant.php';
if (!file_exists($constantPath)) {
    die("Error: Could not find app/Config/constant.php at $constantPath");
}
require_once $constantPath;
echo "<p>Loaded configuration.</p>";

// 2. Load Autoloader
$autoloadPath = __DIR__ . '/app/Vendor/vendor/autoload.php';
if (!file_exists($autoloadPath)) {
    die("Error: Could not find autoload.php at $autoloadPath");
}
require_once $autoloadPath;
echo "<p>Loaded AWS SDK.</p>";

use Aws\S3\S3Client;
use Aws\Exception\AwsException;

// 3. Instantiate S3 Client
echo "<p>Attempting to connect with:</p>";
echo "<ul>";
echo "<li>Key: " . IAM_KEY . "</li>";
echo "<li>Region: " . S3_REGION . "</li>";
echo "<li>Bucket: " . BUCKET_NAME . "</li>";
echo "</ul>";

try {
    $s3 = new S3Client([
        'credentials' => [
            'key'    => IAM_KEY,
            'secret' => IAM_SECRET,
        ],
        'version' => 'latest',
        'region'  => S3_REGION,
    ]);

    // 4. Test Operation: List Buckets
    // This confirms credentials work
    echo "<p>Client created. Attempting to list buckets...</p>";
    
    $result = $s3->listBuckets();
    
    echo "<p style='color:green; font-weight:bold;'>Success! Connection established.</p>";
    echo "<p>Buckets found:</p><ul>";
    foreach ($result['Buckets'] as $bucket) {
        echo "<li>" . $bucket['Name'] . "</li>";
    }
    echo "</ul>";
    
    // 5. Test Write permission
    echo "<p>Attempting to write a test file to bucket '" . BUCKET_NAME . "'...</p>";
    $s3->putObject([
        'Bucket' => BUCKET_NAME,
        'Key'    => 'test_connection_' . time() . '.txt',
        'Body'   => 'This is a test file to verify S3 write access.',
        'ACL'    => 'public-read',
    ]);
    echo "<p style='color:green; font-weight:bold;'>Write Success! Test file uploaded.</p>";

} catch (AwsException $e) {
    echo "<h2 style='color:red;'>AWS Error:</h2>";
    echo "<p><strong>Type:</strong> " . $e->getAwsErrorType() . "</p>";
    echo "<p><strong>Code:</strong> " . $e->getAwsErrorCode() . "</p>";
    echo "<p><strong>Message:</strong> " . $e->getMessage() . "</p>";
} catch (Exception $e) {
    echo "<h2 style='color:red;'>General Error:</h2>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
?>
