<?php

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// 1. Mock CakePHP Constants (Required for Ffmpeg.php to run standalone)
if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
if (!defined('ROOT')) define('ROOT', dirname(dirname(__DIR__))); // Go up from app/webroot to Root
if (!defined('UPLOADS_FOLDER_URI')) define('UPLOADS_FOLDER_URI', __DIR__ . DS . 'uploads');
if (!defined('TEMP_UPLOADS_FOLDER_URI')) define('TEMP_UPLOADS_FOLDER_URI', __DIR__ . DS . 'temp_uploads');
if (!defined('WATERMARK_IMAGE_URI')) define('WATERMARK_IMAGE_URI', __DIR__ . DS . 'watermark.png');
if (!defined('FONT_FOLDER_URI')) define('FONT_FOLDER_URI', __DIR__ . DS . 'fonts');
if (!defined('WATERMARK_VIDEO_URI')) define('WATERMARK_VIDEO_URI', __DIR__ . DS . 'watermark.mp4');

// 2. Include Ffmpeg.php
$ffmpeg_path = __DIR__ . '/../Lib/Ffmpeg.php';
if (file_exists($ffmpeg_path)) {
    require_once($ffmpeg_path);
} else {
    // Provide a clear error if file is missing, bypassing CakePHP if possible
    header("HTTP/1.0 200 OK");
    die("<h1>Error: Could not find app/Lib/Ffmpeg.php</h1><p>Checked path: $ffmpeg_path</p>");
}

echo "<h1>FFmpeg Test Script</h1>";
echo "<p>Running from: " . __DIR__ . "</p>";

// 3. Define Video/Audio Inputs
$video_filename = isset($_GET['video']) ? $_GET['video'] : 'test_video.mp4';
$audio_url = isset($_GET['audio']) ? $_GET['audio'] : 'https://d1dhoq8ayts2dx.cloudfront.net/audio/69720fe9960247ter9.mp3';

// Assuming this script is in app/webroot/
$base_dir = __DIR__ . '/temp_uploads/'; // Adjust if needed
if (!file_exists($base_dir)) {
    mkdir($base_dir, 0777, true);
}

$video_path = $base_dir . $video_filename;

echo "<h3>1. Checking Inputs</h3>";
echo "Video Path: " . $video_path . "<br>";
echo "Audio URL: " . $audio_url . "<br>";

if (!file_exists($video_path)) {
    echo "<p style='color:red'>Video file not found! Please place a video file named '$video_filename' in 'app/webroot/temp_uploads/' folder.</p>";
    exit;
} else {
    echo "<p style='color:green'>Video file found.</p>";
}

echo "<h3>2. Calling Ffmpeg::mergeVideoWithSound</h3>";

$start = microtime(true);
$result = Ffmpeg::mergeVideoWithSound($video_path, $audio_url);
$end = microtime(true);

echo "<p>Time taken: " . number_format($end - $start, 2) . " seconds</p>";

echo "<h3>3. Result</h3>";
if ($result && $result != $video_path && file_exists($result)) {
    echo "<p style='color:green'><b>SUCCESS!</b> Merged file created at: " . $result . "</p>";
    echo "Size: " . filesize($result) . " bytes<br>";
} else {
    echo "<p style='color:red'><b>FAILURE.</b> Returned path is original video or file missing.</p>";
}

echo "<h3>4. Debug Log Content (ffmpeg_debug.log)</h3>";
$log_file = dirname($video_path) . '/ffmpeg_debug.log';
if (file_exists($log_file)) {
    echo "<pre style='background:#f4f4f4; padding:10px; border:1px solid #ccc;'>" . file_get_contents($log_file) . "</pre>";
} else {
    echo "Log file not found at: " . $log_file;
}

?>
