<?php


class WithdrawRequest extends AppModel
{

    public $useTable = 'withdraw_request';

    public $belongsTo = array(

        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',
            'fields' => USER_FIELDS
        ),
    );


    public function getDetails($id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'WithdrawRequest.id'=> $id,




            )
        ));
    }
    public function getWithdrawRequestsAgainstUserID($user_id,$starting_point)
    {
        return $this->find('all', array(
            'conditions' => array(




                //'WithdrawRequest.status'=> $status,
                'WithdrawRequest.user_id'=> $user_id,






            ),

            'limit' => 10,
            'offset' => $starting_point*10,
            'recursive'=>-1,
            'order' => 'WithdrawRequest.id DESC',
        ));
    }
    public function getUserPendingWithdrawRequest($user_id)
    {
        return $this->find('all', array(
            'conditions' => array(



                'WithdrawRequest.user_id'=> $user_id,
                'WithdrawRequest.status'=> 0,




            )
        ));
    }

    public function getUserLastWithdrawRequest($user_id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'WithdrawRequest.user_id'=> $user_id,
                'WithdrawRequest.status'=> 1,




            ),
            'order' => 'WithdrawRequest.id DESC',
        ));
    }
    public function getTotalCoins($user_id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'WithdrawRequest.user_id'=> $user_id,
                'WithdrawRequest.status <'=> 2,




            ),
            'fields'=>array('SUM(WithdrawRequest.coin) as total_coin'),

        ));
    }

    public function getTotalAmountWithdrawal($user_id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'WithdrawRequest.user_id'=> $user_id,
                'WithdrawRequest.status'=> 1,




            ),
            'fields'=>array('SUM(WithdrawRequest.amount) as total_amount'),

        ));
    }

    public function getAllPendingRequests($status)
    {
        return $this->find('all', array(
            'conditions' => array(




                'WithdrawRequest.status'=> array($status,1,2),




            )
        ));
    }




    public function getAll()
    {
        return $this->find('all');
    }







}
?>