<?php


class Video extends AppModel
{

    public $useTable = 'video';

    public $belongsTo = array(
        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',
            'fields' => USER_FIELDS
        ),

        'Sound' => array(
            'className' => 'Sound',
            'foreignKey' => 'sound_id',



        ),

        'Location' => array(
            'className' => 'Location',
            'foreignKey' => 'location_id',



        ),

        'PinComment' => array(
            'className' => 'VideoComment',
            'foreignKey' => 'pin_comment_id',



        ),

        'Product' => array(
            'className' => 'Product',
            'foreignKey' => 'product_id',



        ),


    );

    public $hasMany = array(
        'VideoComment' => array(
            'className' => 'VideoComment',
            'foreignKey' => 'video_id',
            'dependent' =>true



        ),

        'VideoFavourite' => array(
            'className' => 'VideoFavourite',
            'foreignKey' => 'video_id',
            'dependent' =>true



        ),

        'VideoProduct' => array(
            'className' => 'VideoProduct',
            'foreignKey' => 'video_id',
            'dependent' =>true



        ),

        'VideoLike' => array(
            'className' => 'VideoLike',
            'foreignKey' => 'video_id',
            'dependent' =>true



        ),

        'VideoWatch' => array(
            'className' => 'VideoWatch',
            'foreignKey' => 'video_id',
            'dependent' =>true



        ),

        'Notification' => array(
            'className' => 'Notification',
            'foreignKey' => 'video_id',
            'dependent' =>true



        ),


    );


    public $custom_fields = array(
        "Video.id",
        "Video.user_id",
        "Video.description",
        "Video.video",
        "Video.thum",
        "Video.thum_small",
        "Video.gif",
        "Video.view",
        "Video.sound_id",
        "Video.privacy_type",
        "Video.allow_comments",
        "Video.allow_duet",
        "Video.duration",
        "Video.promote",
        "Video.pin_comment_id",
        "Video.pin",
        "Video.location_string",
        "Video.location_id",
        "Video.lat",
        "Video.long",
        "Video.width",
        "Video.height",

        "Video.user_thumbnail",
        "Video.default_thumbnail",
        //"Video.tag_store_id",

    );

    public function getDetails($id)
    {

        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.id'=> $id,




            ),
            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct.Product.ProductImage'),
           // 'contain' => array('Store.StoreAddress','User.PrivacySetting','User.Store','User.PushNotification','VideoComment.User','VideoProduct.Dish','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
        ));
    }

    public function getDetailsAdmin($id)
    {

        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.id'=> $id,




            ),
            //'fields' => $this->custom_fields,
            'contain' => array('VideoComment','Sound'),
            // 'contain' => array('Store.StoreAddress','User.PrivacySetting','User.Store','User.PushNotification','VideoComment.User','VideoProduct.Dish','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
        ));
    }



    public function getObjectsForCache($id)
    {

        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.id'=> $id,




            ),

            'contain' => array('Location','Sound'),
        ));
    }

//
    public function getUserStory($user_id,$date)
    {

        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.created >='=> $date,
                'Video.story'=> 1,




            ),

            'contain' => array('Sound'),
        ));
    }


    public function getUserVideosIDs($user_id)
    {


        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.repost_user_id'=> 0,




            ),
            'fields'=>array('Video.id'),

            'recursive'=>-1
        ));
    }

    public function getDetailsAgainstOldVideoID($old_video_id)
    {


        return $this->find('first', array(
            'conditions' => array(



                'Video.old_video_id'=> $old_video_id,




            ),

            'recursive'=>-1
        ));
    }
    public function ifUserRepostedVideo($user_id,$video_id)
    {



        //$this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.repost_user_id'=> $user_id,
                'Video.repost_video_id'=> $video_id,




            ),

            'recursive' => -1
        ));
    }
    public function getOnlyVideoDetails($video_id)
    {

        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.id'=> $video_id,





            ),
            'contain' => array('User'),
            'recursive'=>-1
        ));
    }

    public function getOnlyVideoDetailsAgainstVideoAndUserID($user_id,$video_id)
    {

        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.id'=> $video_id,
                'Video.user_id'=> $user_id,





            ),
            'contain' => array('User'),
            'recursive'=>-1
        ));
    }

    public function getVideoDetailsAgainstJobID($job_id)
    {


        return $this->find('first', array(
            'conditions' => array(



                'Video.job_id'=> $job_id,





            ),

            'recursive'=>-1
        ));
    }

    public function getVideoDetailsLocation($location_id)
    {


        return $this->find('first', array(
            'conditions' => array(



                'Video.location_id'=> $location_id,
                'Video.tag_store_id'=> 0,





            ),

            'recursive'=>-1
        ));
    }

    public function getSearchResults($keyword,$starting_point,$user_id){


        $this->Behaviors->attach('Containable');
        return $this->find('all', array(

            'conditions' => array(

                'Video.description Like' => "$keyword%",
                //'Video.user_id !=' => $user_id,
                'Video.repost_user_id'=> 0,


            ),
            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct'),
            'limit'=>15,
            'offset' => $starting_point*15,





            'recursive' => 0


        ));

    }

    public function checkDuplicate($data){


        $this->Behaviors->attach('Containable');
        return $this->find('all', array(

            'conditions' => array(

                'Video.description' => $data['description'],
                'Video.user_id=' => $data['user_id'],
                'Video.video' => $data['video'],
                'Video.thum' => $data['thum'],
                'Video.gif' => $data['gif'],
                'Video.repost_user_id'=> 0,



            ),
            'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','Sound'),

            'limit'=>10,






            'recursive' => 0


        ));

    }

    public function getUserRecentVideos($user_id,$start_datetime,$end_datetime)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.privacy_type'=> "public",
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.created >='=> $start_datetime,
                'Video.created <='=> $end_datetime,





            ),
            'contain' => array('Location','Product','User.PrivacySetting','User.Store','User.PushNotification','Sound'),
            'limit' => 7,

            'order' => 'Video.id DESC'


        ));
    }

    public function getUserTrendingVideos($user_id,$start_datetime,$end_datetime)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.privacy_type'=> "public",
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.created >='=> $start_datetime,
                'Video.created <='=> $end_datetime,





            ),
            'contain' => array('Location','Product','User.PrivacySetting','User.Store','User.PushNotification','Sound'),
            'limit' => 9,

            'order' => 'Video.view DESC'


        ));
    }
    public function getUserPublicVideos($user_id,$starting_point)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.user_id > '=> 0,
                'Video.privacy_type'=> "public",
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,





            ),
            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct'),
            'recursive'=>-1,
            'limit' => APP_RECORDS_PER_PAGE,
            'offset' => $starting_point*APP_RECORDS_PER_PAGE,
            'order' => 'Video.id DESC'


        ));
    }

    public function getUserProductTaggedVideos($user_id,$starting_point)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.privacy_type'=> "public",
                'Video.repost_user_id'=> 0,
                'Video.tag_product'=> 1,
                'Video.story'=> 0,





            ),
            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct'),
            'limit' => APP_RECORDS_PER_PAGE,
            'offset' => $starting_point*APP_RECORDS_PER_PAGE,
            'order' => 'Video.id DESC'


        ));
    }

    public function getUserPublicVideosAdmin($user_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.user_id > '=> 0,
                'Video.privacy_type'=> array("public","Public"),
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,




            ),
           // 'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User'),
            'order' => 'Video.id DESC',
            'recursive'=>-1


        ));
    }

    public function getUserPrivateVideosAdmin($user_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.privacy_type'=> "private",
                'Video.repost_user_id'=> 0,




            ),
            'recursive'=>-1,
            //'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User'),


            'order' => 'Video.id DESC'


        ));
    }

    public function getUserVideos($user_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.repost_user_id'=> 0,




            ),
            'contain' => array('Location','Product','User.PrivacySetting','User.Store','User.PushNotification','Sound'),
            'order' => 'Video.id DESC'


        ));
    }



    public function getAllVideos($starting_point)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(


            'order' => 'Video.id DESC',
            'contain' => array('User','Sound'),
            'limit'=>ADMIN_RECORDS_PER_PAGE,
            'offset' => $starting_point*ADMIN_RECORDS_PER_PAGE,

        ));
    }

    public function getAllNudityDetectedVideos($starting_point)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(

            'conditions' => array(



                'Video.nudity_found'=> 1,
            ),

            'order' => 'Video.id DESC',
            'contain' => array('User','Sound'),
            'limit'=>ADMIN_RECORDS_PER_PAGE,
            'offset' => $starting_point*ADMIN_RECORDS_PER_PAGE,

        ));
    }

    public function tempvideos(){

       return $this->query("SELECT * FROM video as Video WHERE ai_json IS NULL OR CHAR_LENGTH(ai_json) <= 4 AND ai_done != 2 ORDER BY Video.id DESC LIMIT 100 ");
    }

    public function getAllUserVideos($user_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
            ),

            'order' => 'Video.id DESC',

            'recursive'=>-1


        ));
    }

    public function getUserPrivateVideos($user_id,$starting_point)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.user_id >'=> 0,
                'Video.privacy_type'=> "private",
                'Video.repost_user_id'=> 0,




            ),

            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct'),
           // 'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User'),
            'limit' => APP_RECORDS_PER_PAGE,
            'offset' => $starting_point*APP_RECORDS_PER_PAGE,
            'order' => 'Video.id DESC'


        ));
    }

    public function getUserVideosCount($user_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('count', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.repost_user_id'=> 0,




            ),






        ));
    }

    public function countUserVideosViews($user_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.user_id'=> $user_id,
                'Video.repost_user_id'=> 0,





            ),
            'fields'=>array('SUM(Video.view) as total_views'),






        ));
    }


    public function getVideosCountAgainstSound($sound_id)
    {

        return $this->find('count', array(
            'conditions' => array(



                'Video.sound_id'=> $sound_id,





            ),






        ));
    }


    public function getFrequentlyUsedSounds()
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(

            'conditions' => array(

                'Video.privacy_type'=> 'public',
                'Video.repost_user_id'=> 0,
            ),
            'fields' => array( 'DISTINCT Video.sound_id','COUNT(*) count'),

            'group' => array('Video.sound_id'),
            'order' => 'COUNT(*) DESC',




        ));
    }

    public function getVideosAgainstSoundID($user_id,$starting_id,$sound_id)
    {
        $this->Behaviors->attach('Containable');



        return $this->find('all', array(
            // 'fields' => array('id'),
            'conditions' => array(

                'Video.sound_id'=> $sound_id,
                'Video.repost_user_id'=> 0,
                'Video.privacy_type'=> 'public'
            ),
            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct'),
            'limit' => APP_RECORDS_PER_PAGE,
            'offset' => $starting_id*APP_RECORDS_PER_PAGE,
            'order' => 'Video.view DESC'
        ));

    }

    public function getVideosAgainstLocation($location_id,$starting_point)
    {
        $this->Behaviors->attach('Containable');



        return $this->find('all', array(
            // 'fields' => array('id'),
            'conditions' => array(

                'Video.location_id'=> $location_id,
                'Video.repost_user_id'=> 0,
                'Video.privacy_type'=> 'public'
            ),
            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct'),
            'limit' => APP_RECORDS_PER_PAGE,
            'offset' => $starting_point*APP_RECORDS_PER_PAGE,
            'order' => 'Video.view DESC'
        ));

    }


    public function getVideosAgainstSoundIDWeb($user_id,$device_id,$starting_id,$sound_id)
    {
        $this->Behaviors->attach('Containable');



        return $this->find('all', array(
            // 'fields' => array('id'),
            'conditions' => array(

                'Video.sound_id'=> $sound_id,
                'Video.repost_user_id'=> 0,
                'Video.privacy_type'=> 'public'
            ),
            'contain' => array('Location','Product','User.PrivacySetting','User.Store','User.PushNotification','Sound'),

            'order' => 'Video.view DESC'
        ));

    }

    public function getPromotedVideo()
    {
        $this->Behaviors->attach('Containable');



        return $this->find('first', array(
            // 'fields' => array('id'),
            'conditions' => array(

                'Video.promote'=> 1,
                'Video.repost_user_id'=> 0,

            ),
            'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','Sound'),

            'order' => 'rand()'
        ));

    }


    public function getRelatedVideosNotWatched($user_id,$device_id,$tag_product,$starting_id)
    {
        $this->Behaviors->attach('Containable');


        if($tag_product == 1){

            //show videos which has products

            $condition =  array(

                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.tag_product'=> $tag_product,
                'Video.privacy_type'=> 'public',
                'NotInterestedVideo.user_id IS NULL',
                'BlockUser.user_id IS NULL',
                'VideoWatch.user_id IS NULL',

            );
        }else{

            //show all products

            $condition =  array(

                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,

                'Video.privacy_type'=> 'public',
                'NotInterestedVideo.user_id IS NULL',
                'BlockUser.user_id IS NULL',
                'VideoWatch.user_id IS NULL',

            );
        }

        $join_condition = array(
            array(
                'table' => 'not_interested_video',
                'alias' => 'NotInterestedVideo',
                'type' => 'LEFT',
                'conditions' => array(
                    'NotInterestedVideo.video_id = Video.id',
                    'NotInterestedVideo.user_id = ' . $user_id
                )
            ),

            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),

            array(
                'table' => 'video_watch',
                'alias' => 'VideoWatch',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.id = VideoWatch.video_id',
                    'VideoWatch.user_id = ' . $user_id
                )
            )
        );


        return $this->find('all', array(
            // 'fields' => array('id'),

            'joins' => $join_condition,

            'conditions' => $condition,


            'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','PinComment','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
            'limit' => 15,
            'offset' => $starting_id*15,
          //  'order' => 'rand()'
            'order' => 'Video.view DESC'
        ));

    }

    public function getAllVideosAgainstVideoIDS($video_ids)
    {
        $this->Behaviors->attach('Containable');





            //show videos which has products

            $condition =  array(


                'Video.id IN'=> $video_ids,


            );




        return $this->find('all', array(
            // 'fields' => array('id'),


            'contain' => array('VideoProduct'),
            'conditions' => $condition,
            'fields' => $this->custom_fields,


           // 'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','PinComment','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
            //'order' => "FIELD(Video.id, $videoIdsString)",

        ));

    }



    public function getNearbyVideos($lat,$long,$user_id,$starting_id)
    {
        $this->Behaviors->attach('Containable');


        $join_condition = array(


            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),


        );


        return $this->find('all', array(
            // 'fields' => array('id'),

            'joins' => $join_condition,

            'conditions' => array(

                //'Video.user_id !='=> $user_id,
                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.user_id >'=> 0,
                'Video.story'=> 0,
                'Video.privacy_type'=> 'public',
                'BlockUser.user_id IS NULL',


            ),



          'contain' => array('VideoProduct'),
            'fields'=>$this->custom_fields,
            //'recursive'=>-1,
            'limit' => 25,
            'offset' => $starting_id*25,
           // 'order' => 'rand()',
            'having' => array(
                '3959 * acos(
            cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
            sin(radians(' . $lat . ')) * sin(radians(Video.lat))
        ) < 1000', // Replace "25" with the distance range you want in miles
            ),
            'order' => '3959 * acos(
        cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
        sin(radians(' . $lat . ')) * sin(radians(Video.lat))
    ) ASC',
        ));

    }


    public function getNearbyRelatedVideosWatchedLimit($lat,$long,$user_id,$starting_id,$limit)
    {
        $this->Behaviors->attach('Containable');



        $join_condition = array(
            array(
                'table' => 'not_interested_video',
                'alias' => 'NotInterestedVideo',
                'type' => 'LEFT',
                'conditions' => array(
                    'NotInterestedVideo.video_id = Video.id',
                    'NotInterestedVideo.user_id = ' . $user_id
                )
            ),

            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),


        );



        return $this->find('all', array(
            // 'fields' => array('id'),
            'joins' => $join_condition,
            'conditions' => array(

                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.privacy_type'=> 'public',
                'NotInterestedVideo.user_id IS NULL',
                'BlockUser.user_id IS NULL',

            ),
            'contain' => array('VideoProduct'),
            'limit' => $limit,
            'offset' => $starting_id*15,

            'having' => array(
                '3959 * acos(
            cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
            sin(radians(' . $lat . ')) * sin(radians(Video.lat))
        ) < 10000', // Replace "25" with the distance range you want in miles
            ),
            'order' => '3959 * acos(
        cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
        sin(radians(' . $lat . ')) * sin(radians(Video.lat))
    ) ASC',
        ));
    }





    public function getVideosWhichAreNotCompressedAndNotQualityChecked()
    {

        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'Video.privacy_type'=> "public",
                'Video.compression'=> 0,
                'Video.quality_check'=> 0,
                'Video.error'=> 0,







            ),
            'limit'=>1,
            'order'=>'Video.id DESC',
            'recursive'=>-1

        ));
    }


    public function getRelatedVideos($user_id,$starting_id)
    {
        $this->Behaviors->attach('Containable');




            //show all products

            $condition =  array(

                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.user_id >'=> 0,
                'Video.privacy_type'=> 'public',

                'BlockUser.user_id IS NULL',

            );



        $join_condition = array(


            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),


        );



        return $this->find('all', array(
             'fields' => $this->custom_fields,
            'joins' => $join_condition,
            'conditions' => $condition,
            //'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
            'contain' => array('VideoProduct'),
            'limit' => 25,
            'order' => 'Video.viral DESC',
            'offset' => $starting_id*25,
            //'recursive'=>-1,

           /* 'having' => array(
                '3959 * acos(
            cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
            sin(radians(' . $lat . ')) * sin(radians(Video.lat))
        ) < 1000', // Replace "25" with the distance range you want in miles
            ),
            'order' => '3959 * acos(
        cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
        sin(radians(' . $lat . ')) * sin(radians(Video.lat))
    ) ASC',*/
        ));

    }

    public function getRelatedVideosDemo($user_id,$starting_id)
    {
        $this->Behaviors->attach('Containable');




        //show all products

        $condition =  array(

            'Video.block'=> 0,
            'Video.repost_user_id'=> 0,
            'Video.story'=> 0,
            'Video.user_id >'=> 0,
          
            'Video.privacy_type'=> 'public',

            'BlockUser.user_id IS NULL',

        );



        $join_condition = array(


            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),


        );



        return $this->find('all', array(
            'fields' => $this->custom_fields,
            'joins' => $join_condition,
            'conditions' => $condition,
            //'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
            'contain' => array('VideoProduct'),
            'limit' => 25,
            'order' => 'Video.viral DESC',
            'offset' => $starting_id*25,
            //'recursive'=>-1,

            /* 'having' => array(
                 '3959 * acos(
             cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
             sin(radians(' . $lat . ')) * sin(radians(Video.lat))
         ) < 1000', // Replace "25" with the distance range you want in miles
             ),
             'order' => '3959 * acos(
         cos(radians(' . $lat . ')) * cos(radians(Video.lat)) * cos(radians(Video.long) - radians(' . $long . ')) +
         sin(radians(' . $lat . ')) * sin(radians(Video.lat))
     ) ASC',*/
        ));

    }
    public function getRelatedVideosRandom($user_id,$starting_id)
    {
        $this->Behaviors->attach('Containable');


            //show all products

            $condition =  array(

                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.user_id >'=> 0,



                'Video.privacy_type'=> 'public',

                'BlockUser.user_id IS NULL',

            );



        $join_condition = array(


            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),


        );


        return $this->find('all', array(
            'fields' => $this->custom_fields,
            'joins' => $join_condition,
            'conditions' => $condition,
            //'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
            'contain' => array('VideoProduct'),
            'limit' => 25,
            'order'=>'rand()',

            'offset' => $starting_id*25,
            'recursive'=>-1,


        ));

    }

    public function getRelatedVideosWatchedLimit($user_id,$device_id,$tag_product,$starting_id,$limit)
    {
        $this->Behaviors->attach('Containable');


        if($tag_product == 1){

            //show videos which has products

            $condition =  array(

                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.tag_product'=> $tag_product,
                'Video.privacy_type'=> 'public',
                'NotInterestedVideo.user_id IS NULL',
                'BlockUser.user_id IS NULL',

            );
        }else{

            //show all products

            $condition =  array(

                'Video.block'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,

                'Video.privacy_type'=> 'public',
                'NotInterestedVideo.user_id IS NULL',
                'BlockUser.user_id IS NULL',

            );
        }


        $join_condition = array(
            array(
                'table' => 'not_interested_video',
                'alias' => 'NotInterestedVideo',
                'type' => 'LEFT',
                'conditions' => array(
                    'NotInterestedVideo.video_id = Video.id',
                    'NotInterestedVideo.user_id = ' . $user_id
                )
            ),

            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),


        );



        return $this->find('all', array(
            // 'fields' => array('id'),
            'joins' => $join_condition,
            'conditions' => $condition,
            'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User','VideoProduct.Store.StoreAddress','VideoProduct.Store.StoreLocalHours'),
            'limit' => $limit,
            'offset' => $starting_id*$limit,

            //'order' => 'rand()'
            'order' => 'Video.view DESC'
        ));

    }



    public function getFollowingVideos($user_id,$starting_id,$ids)
    {
        $this->Behaviors->attach('Containable');


        $join_condition = array(


            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            ),

        );
        return $this->find('all', array(
            'joins' => $join_condition,
            // 'fields' => array('id'),
            'conditions' => array(

                'Video.privacy_type'=> 'public',
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,
                'Video.block'=> 0,
                'Video.user_id IN'=> $ids,

                'BlockUser.user_id IS NULL',


            ),
            'fields' => $this->custom_fields,
            'contain' => array('VideoProduct'),
           // 'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','User.Store','Sound','VideoProduct.Store.User','VideoProduct.Store.StoreLocalHours'),
            'limit' => 15,
            'offset' => $starting_id*15,
            'recursive'=>-1,

            'order' => 'Video.id DESC'
            //'order' => 'Video.view DESC'
        ));



    }


    public function getFollowingVideosWatched($user_id,$starting_id,$ids,$limit)
    {
        $this->Behaviors->attach('Containable');

        $join_condition = array(
            array(
                'table' => 'not_interested_video',
                'alias' => 'NotInterestedVideo',
                'type' => 'LEFT',
                'conditions' => array(
                    'NotInterestedVideo.video_id = Video.id',
                    'NotInterestedVideo.user_id = ' . $user_id
                )
            ),

            array(
                'table' => 'block_user',
                'alias' => 'BlockUser',
                'type' => 'LEFT',
                'conditions' => array(
                    'Video.user_id = BlockUser.block_user_id',
                    'BlockUser.user_id = ' . $user_id
                )
            )
        );

        return $this->find('all', array(
            'joins' => $join_condition,
            // 'fields' => array('id'),
            'conditions' => array('exists '.
                '(SELECT id FROM follower as Follower WHERE Video.user_id = Follower.receiver_id AND Follower.sender_id ='.$user_id.')',


                'Video.block'=> 0,
                'Video.story'=> 0,
                'Video.repost_user_id'=> 0,
                'Video.user_id IN'=> $ids,

                'Video.privacy_type'=> 'public',
                'NotInterestedVideo.user_id IS NULL',
                'BlockUser.user_id IS NULL'
            ),
            'contain' => array('Location','Product','User.PrivacySetting','User.PushNotification','Sound','User.Store','VideoProduct.Store.User','VideoProduct.Store.StoreLocalHours'),
            'limit' => $limit,
            'offset' => $starting_id*$limit,

            'order' => 'Video.id DESC'
            //'order' => 'Video.view DESC'
        ));

    }

    public function getAllVideosAgainstSoundID($sound_id)
    {




        return $this->find('all', array(

            'conditions' => array(


                'Video.sound_id'=> $sound_id,
                'Video.repost_user_id'=> 0,
                'Video.story'=> 0,

            ),
            'recursive' => -1,


        ));

    }
    public function getAllVideostemp()
    {




        return $this->find('all', array(

            'conditions' => array(


                'Video.lat IS NOT NULL',
                'Video.lat !=' => '',
                'Video.location_id' => 0,
                //'Video.length >' => 2

            ),
            'recursive' => -1,


        ));

    }
    public function updateSoundIDs($ids){


        $this->updateAll(
            array('sound_id' => 0),
            array('Video.sound_id IN' => $ids)
        );
    }







}
?>