<?php



class InterestSection extends AppModel
{
    public $useTable = 'interest_section';

    public $hasMany = array(

        'Interest' => array(
            'className' => 'Interest',
            'foreignKey' => 'interest_section_id',
            'dependent'=>true


        ),

    );

    public function getDetails($id)
    {
        return $this->find('first', array(
            'conditions' => array(

                'InterestSection.id' => $id





            ),

            'contain' => array(
                'Interest' => array(

                    'order' => 'Interest.order ASC',

                )
            ),
        ));
    }


    public function getAllNotAllegens()
    {
        return $this->find('all', array(

            'conditions' => array(



                'InterestSection.title !='=> "allegens",




            ),
            'contain' => array(
                'Interest' => array(

                    'order' => 'Interest.order ASC',

                )
            ),
            'order' => 'InterestSection.order ASC'
        ));

    }

    public function getOnlySection()
    {
        return $this->find('all', array(

            'order' => 'InterestSection.order ASC',
            'recursive'=>-1,
        ));

    }

    public function ifExist($title)
    {
        return $this->find('first', array(
            'conditions' => array(



                'InterestSection.title'=> $title,




            ),

        ));
    }







}