<?php
// Turn on error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Full Sound Upload Test (AWS + DB)</h1>";

// 1. Load Constants
if (!defined('ROOT')) {
    define('ROOT', __DIR__);
}
$constantPath = __DIR__ . '/app/Config/constant.php';
if (!file_exists($constantPath)) {
    die("Error: Could not find app/Config/constant.php at $constantPath");
}
require_once $constantPath;
echo "<p>Loaded configuration.</p>";

// 2. Load Autoloader for AWS
$autoloadPath = __DIR__ . '/app/Vendor/vendor/autoload.php';
if (!file_exists($autoloadPath)) {
    die("Error: Could not find autoload.php at $autoloadPath");
}
require_once $autoloadPath;
use Aws\S3\S3Client;
use Aws\Exception\AwsException;

// 3. Setup AWS
$s3 = null;
$s3_url = "";
try {
    echo "<p>Connecting to AWS S3...</p>";
    $s3 = new S3Client([
        'credentials' => [
            'key'    => IAM_KEY,
            'secret' => IAM_SECRET,
        ],
        'version' => 'latest',
        'region'  => S3_REGION,
    ]);
    
    // Upload dummy file
    $key = 'test_sound_' . time() . '.txt';
    $result = $s3->putObject([
        'Bucket' => BUCKET_NAME,
        'Key'    => $key,
        'Body'   => 'Dummy sound content for testing.',
        'ACL'    => 'public-read',
    ]);
    
    $s3_url = $result['ObjectURL'];
    echo "<p style='color:green;'>S3 Upload Success! URL: " . $s3_url . "</p>";

} catch (Exception $e) {
    echo "<p style='color:red;'>S3 Failed: " . $e->getMessage() . "</p>";
    // We continue to test DB even if S3 fails, just to check DB connectivity
}

// 4. Setup Database Connection
echo "<p>Connecting to Database...</p>";
$pdo = null;
try {
    $dsn = "mysql:host=" . DATABASE_HOST . ";dbname=" . DATABASE_NAME . ";charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];
    $pdo = new PDO($dsn, DATABASE_USER, DATABASE_PASSWORD, $options);
    echo "<p style='color:green;'>Database Connected successfully.</p>";
} catch (PDOException $e) {
    die("<p style='color:red;'>Database Connection Failed: " . $e->getMessage() . "</p>");
}

// 5. Insert into Sound Table
if ($pdo) {
    try {
        echo "<p>Attempting to insert record into 'sound' table...</p>";
        
        $sql = "INSERT INTO sound (name, description, uploaded_by, publish, created, sound_section_id, audio, thum, duration) 
                VALUES (:name, :description, :uploaded_by, :publish, :created, :sound_section_id, :audio, :thum, :duration)";
        
        $stmt = $pdo->prepare($sql);
        
        $data = [
            'name' => 'Test Sound Script',
            'description' => 'Created via test_sound_full.php',
            'uploaded_by' => 'admin',
            'publish' => 1,
            'created' => date('Y-m-d H:i:s'),
            'sound_section_id' => 0, // Using 0 or a valid ID if known. 
            'audio' => $s3_url ? $s3_url : 'http://dummy/audio.mp3',
            'thum' => 'http://dummy/thum.jpg',
            'duration' => '10'
        ];
        
        $stmt->execute($data);
        $lastId = $pdo->lastInsertId();
        
        echo "<p style='color:green; font-weight:bold;'>Database Insert Success! New Sound ID: " . $lastId . "</p>";
        
        // Verify insert
        $checkStmt = $pdo->query("SELECT * FROM sound WHERE id = $lastId");
        $row = $checkStmt->fetch();
        echo "<pre>";
        print_r($row);
        echo "</pre>";
        
    } catch (PDOException $e) {
        echo "<p style='color:red; font-weight:bold;'>Database Insert Failed: " . $e->getMessage() . "</p>";
    }
}
?>
