<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/firestore/v1/firestore.proto

namespace Google\Cloud\Firestore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request for
 * [Firestore.PartitionQuery][google.firestore.v1.Firestore.PartitionQuery].
 *
 * Generated from protobuf message <code>google.firestore.v1.PartitionQueryRequest</code>
 */
class PartitionQueryRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $parent = '';
    /**
     * The desired maximum number of partition points.
     * The partitions may be returned across multiple pages of results.
     * The number must be positive. The actual number of partitions
     * returned may be fewer.
     * For example, this may be set to one fewer than the number of parallel
     * queries to be run, or in running a data pipeline job, one fewer than the
     * number of workers or compute instances available.
     *
     * Generated from protobuf field <code>int64 partition_count = 3;</code>
     */
    private $partition_count = 0;
    /**
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     */
    private $page_token = '';
    /**
     * The maximum number of partitions to return in this call, subject to
     * `partition_count`.
     * For example, if `partition_count` = 10 and `page_size` = 8, the first call
     * to PartitionQuery will return up to 8 partitions and a `next_page_token`
     * if more results exist. A second call to PartitionQuery will return up to
     * 2 partitions, to complete the total of 10 specified in `partition_count`.
     *
     * Generated from protobuf field <code>int32 page_size = 5;</code>
     */
    private $page_size = 0;
    protected $query_type;
    protected $consistency_selector;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource name. In the format:
     *           `projects/{project_id}/databases/{database_id}/documents`.
     *           Document resource names are not supported; only database resource names
     *           can be specified.
     *     @type \Google\Cloud\Firestore\V1\StructuredQuery $structured_query
     *           A structured query.
     *           Query must specify collection with all descendants and be ordered by name
     *           ascending. Other filters, order bys, limits, offsets, and start/end
     *           cursors are not supported.
     *     @type int|string $partition_count
     *           The desired maximum number of partition points.
     *           The partitions may be returned across multiple pages of results.
     *           The number must be positive. The actual number of partitions
     *           returned may be fewer.
     *           For example, this may be set to one fewer than the number of parallel
     *           queries to be run, or in running a data pipeline job, one fewer than the
     *           number of workers or compute instances available.
     *     @type string $page_token
     *           The `next_page_token` value returned from a previous call to
     *           PartitionQuery that may be used to get an additional set of results.
     *           There are no ordering guarantees between sets of results. Thus, using
     *           multiple sets of results will require merging the different result sets.
     *           For example, two subsequent calls using a page_token may return:
     *            * cursor B, cursor M, cursor Q
     *            * cursor A, cursor U, cursor W
     *           To obtain a complete result set ordered with respect to the results of the
     *           query supplied to PartitionQuery, the results sets should be merged:
     *           cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     *     @type int $page_size
     *           The maximum number of partitions to return in this call, subject to
     *           `partition_count`.
     *           For example, if `partition_count` = 10 and `page_size` = 8, the first call
     *           to PartitionQuery will return up to 8 partitions and a `next_page_token`
     *           if more results exist. A second call to PartitionQuery will return up to
     *           2 partitions, to complete the total of 10 specified in `partition_count`.
     *     @type \Google\Protobuf\Timestamp $read_time
     *           Reads documents as they were at the given time.
     *           This must be a microsecond precision timestamp within the past one hour,
     *           or if Point-in-Time Recovery is enabled, can additionally be a whole
     *           minute timestamp within the past 7 days.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Firestore\V1\Firestore::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents`.
     * Document resource names are not supported; only database resource names
     * can be specified.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     *
     * Generated from protobuf field <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     * @return \Google\Cloud\Firestore\V1\StructuredQuery|null
     */
    public function getStructuredQuery()
    {
        return $this->readOneof(2);
    }

    public function hasStructuredQuery()
    {
        return $this->hasOneof(2);
    }

    /**
     * A structured query.
     * Query must specify collection with all descendants and be ordered by name
     * ascending. Other filters, order bys, limits, offsets, and start/end
     * cursors are not supported.
     *
     * Generated from protobuf field <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     * @param \Google\Cloud\Firestore\V1\StructuredQuery $var
     * @return $this
     */
    public function setStructuredQuery($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Firestore\V1\StructuredQuery::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The desired maximum number of partition points.
     * The partitions may be returned across multiple pages of results.
     * The number must be positive. The actual number of partitions
     * returned may be fewer.
     * For example, this may be set to one fewer than the number of parallel
     * queries to be run, or in running a data pipeline job, one fewer than the
     * number of workers or compute instances available.
     *
     * Generated from protobuf field <code>int64 partition_count = 3;</code>
     * @return int|string
     */
    public function getPartitionCount()
    {
        return $this->partition_count;
    }

    /**
     * The desired maximum number of partition points.
     * The partitions may be returned across multiple pages of results.
     * The number must be positive. The actual number of partitions
     * returned may be fewer.
     * For example, this may be set to one fewer than the number of parallel
     * queries to be run, or in running a data pipeline job, one fewer than the
     * number of workers or compute instances available.
     *
     * Generated from protobuf field <code>int64 partition_count = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setPartitionCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->partition_count = $var;

        return $this;
    }

    /**
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The `next_page_token` value returned from a previous call to
     * PartitionQuery that may be used to get an additional set of results.
     * There are no ordering guarantees between sets of results. Thus, using
     * multiple sets of results will require merging the different result sets.
     * For example, two subsequent calls using a page_token may return:
     *  * cursor B, cursor M, cursor Q
     *  * cursor A, cursor U, cursor W
     * To obtain a complete result set ordered with respect to the results of the
     * query supplied to PartitionQuery, the results sets should be merged:
     * cursor A, cursor B, cursor M, cursor Q, cursor U, cursor W
     *
     * Generated from protobuf field <code>string page_token = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * The maximum number of partitions to return in this call, subject to
     * `partition_count`.
     * For example, if `partition_count` = 10 and `page_size` = 8, the first call
     * to PartitionQuery will return up to 8 partitions and a `next_page_token`
     * if more results exist. A second call to PartitionQuery will return up to
     * 2 partitions, to complete the total of 10 specified in `partition_count`.
     *
     * Generated from protobuf field <code>int32 page_size = 5;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of partitions to return in this call, subject to
     * `partition_count`.
     * For example, if `partition_count` = 10 and `page_size` = 8, the first call
     * to PartitionQuery will return up to 8 partitions and a `next_page_token`
     * if more results exist. A second call to PartitionQuery will return up to
     * 2 partitions, to complete the total of 10 specified in `partition_count`.
     *
     * Generated from protobuf field <code>int32 page_size = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Reads documents as they were at the given time.
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp read_time = 6;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getReadTime()
    {
        return $this->readOneof(6);
    }

    public function hasReadTime()
    {
        return $this->hasOneof(6);
    }

    /**
     * Reads documents as they were at the given time.
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp read_time = 6;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setReadTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getQueryType()
    {
        return $this->whichOneof("query_type");
    }

    /**
     * @return string
     */
    public function getConsistencySelector()
    {
        return $this->whichOneof("consistency_selector");
    }

}

